/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.lobbysounds;

import club.sk1er.lobbysounds.command.LobbySoundsCommand;
import club.sk1er.lobbysounds.config.Sounds;
import club.sk1er.modcore.ModCoreInstaller;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="lobby_sounds", name="Lobby Sounds", version="1.0", acceptedMinecraftVersions="[1.8.9]")
public class LobbySounds {
    private static final String COMPASS_NAME = EnumChatFormatting.GREEN + "Game Menu " + EnumChatFormatting.GRAY + "(Right Click)";
    private static final String COMPASS_LORE = EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC.toString() + EnumChatFormatting.GRAY + "Right Click to bring up the Game Menu!";
    private boolean inHypixelLobby;
    private boolean onHypixel;
    private Sounds sounds;
    @Mod.Instance(value="lobby_sounds")
    public static LobbySounds instance;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCoreInstaller.initializeModCore(Minecraft.func_71410_x().field_71412_D);
        this.sounds = new Sounds();
        this.sounds.preload();
        ClientCommandHandler.instance.func_71560_a((ICommand)new LobbySoundsCommand());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.runLobbyCheckerTimer();
    }

    @SubscribeEvent
    public void soundPlay(PlaySoundEvent event) {
        String soundName = event.name;
        if (this.onHypixel && this.inHypixelLobby) {
            if (soundName.startsWith("mob.slime") && Sounds.DISABLE_SLIME_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("mob.enderdragon") && Sounds.DISABLE_DRAGON_SOUNDS) {
                this.setNullResult(event);
            }
            if ((soundName.startsWith("mob.wither") || soundName.startsWith("mob.skeleton")) && Sounds.DISABLE_WITHER_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("random.orb") && Sounds.DISABLE_EXPERIENCE_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("random.pop") && Sounds.DISABLE_ITEM_PICKUP_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("game.tnt.primed") && Sounds.DISABLE_TNT_PRIME_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("random.explode") && Sounds.DISABLE_EXPLOSION_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("mob.chicken.plop") && Sounds.DISABLE_DELIVERY_MAN_SOUNDS) {
                this.setNullResult(event);
            }
            if ((soundName.startsWith("note.") || soundName.equals("random.click")) && Sounds.DISABLE_NOTE_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("fireworks") && Sounds.DISABLE_FIREWORKS_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("random.levelup") && Sounds.DISABLE_LEVELUP_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("step.") && Sounds.DISABLE_STEP_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("mob.bat") && Sounds.DISABLE_BAT_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.equals("fire.fire") && Sounds.DISABLE_FIRE_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("mob.endermen") && Sounds.DISABLE_ENDERMEN_SOUNDS) {
                this.setNullResult(event);
            }
            if (soundName.startsWith("random.bow") && Sounds.DISABLE_ARROW_SOUNDS) {
                this.setNullResult(event);
            }
        }
    }

    private void setNullResult(PlaySoundEvent event) {
        event.result = null;
    }

    private void runLobbyCheckerTimer() {
        final Minecraft mc = Minecraft.func_71410_x();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                LobbySounds.this.checkForItem(mc);
                LobbySounds.this.checkIp(mc);
            }
        }, 1000L, 1000L);
    }

    private void checkIp(Minecraft mc) {
        String ip;
        if (mc.func_147104_D() != null && ((ip = mc.func_147104_D().field_78845_b.toLowerCase()).equals("hypixel.net") || ip.endsWith(".hypixel.net") || ip.contains(".hypixel.net:") || ip.startsWith("hypixel.net:"))) {
            this.onHypixel = true;
            return;
        }
        this.onHypixel = false;
    }

    private void checkForItem(Minecraft mc) {
        List tooltip;
        ItemStack itemStack;
        if (mc != null && mc.field_71439_g != null && mc.field_71439_g.field_71071_by != null && (itemStack = mc.field_71439_g.field_71071_by.func_70301_a(0)) != null && itemStack.func_82837_s() && itemStack.func_82833_r().equals(COMPASS_NAME) && ((String)(tooltip = itemStack.func_82840_a((EntityPlayer)mc.field_71439_g, false)).get(1)).equals(COMPASS_LORE)) {
            this.inHypixelLobby = true;
            return;
        }
        this.inHypixelLobby = false;
    }

    public Sounds getSounds() {
        return this.sounds;
    }
}

